
var HOST = 'localhost';

var dgram = require('dgram');


function LLPortData(port){
 
	this.send = function(message, callback){
		var client = dgram.createSocket("udp4");
		 
		client.on('error', function(e) {
			console.log("UDP on error in Data client port");
			console.log(JSON.stringify(e));
		});
		 
		client.on("message", function (msg, rinfo) {
				
				callback(msg);
				client.close();
				//console.log("socket closed " + msg);
			});
		 
		
		try{
			client.send(message, 0, message.length, port, HOST, function(err, bytes) {
				if (err) {
					console.log("UDP error in Data  port");
					console.log(JSON.stringify(err));
				}
			});
		}
		catch(err){
			console.log("UDP error in Data client port...outer error");
			console.log(JSON.stringify(err));
		}
	};
} 

exports.JensClass= function JensPort(port){

	var socket;

	this.start = function(/*int*/ freqMillis, dataCallback){
		socket = dgram.createSocket("udp4");
		var buffer = new Buffer(1);
		var int8View = new Int8Array(buffer);
		buffer[0] = freqMillis;
		
		socket.send(buffer, 0, 1, port, HOST, function(err, bytes) {
			if (err) {
				console.log("UDP error in scan Jens port");
				console.log(JSON.stringify(err));
			}
		});
		
		socket.on('message', function (message, remote) {
		//console.log('received message' + message.length);
			dataCallback(message);
			
			
		});
		
		socket.on('error', function(e) {
			console.log("UDP on error in Jens client port");
			console.log(JSON.stringify(e));
		});
		
		
	};

}


//exports.jens_voigt_port = new JensPort(55554)
exports.get_values_port = new LLPortData(55553);
exports.set_values_port = new LLPortData(55552);




