var net = require('net');

var HOST = '127.0.0.1';
var PORT = 6969;

var client = new net.Socket();

function LLPortData(port){
 
	this.send = function(message, callback){
		
		try{
			
			client.connect(PORT, HOST, function() {
			    console.log('CONNECTED TO: ' + HOST + ':' + PORT);
			    // Write a message to the socket as soon as the client is connected, the server will receive it as message from the client 
			    client.write(message);
			});
			
		}
		catch(err){
			console.log("UDP error in Data client port...outer error");
			console.log(JSON.stringify(err));
		}
		
		// Add a 'data' event handler for the client socket
		// data is what the server sent to this socket
		client.on('data', function(data) {
		    callback(data);
		    console.log('DATA: ' + data);
		    // Close the client socket completely
		    client.destroy();
		    
		});
		
		// Add a 'close' event handler for the client socket
		client.on('close', function() {
		    console.log('Connection closed');
		});
	};
} 

var get_values_port = new LLPortData(55553);
get_values_port.send("foo", function(data){
	console.log("client received: " + data);
});

