//dgram for udp ports
var dgram = require('dgram');

//net for tcp ports
var net = require('net');

var HOST = 'localhost';

var debug_tcp = require('debug')('tcp');



exports.LLPortRequesterTCPClass = function LLPortDataTCP(){
	var client = new net.Socket();
	var repeatingCallbackMap = new Object();
	
	var connectEstablished = false;
	
	this.isConnectEstablished = function(){
		return connectEstablished;
	}
	
	this.registerCallBack = function(requestId, callback){
		repeatingCallbackMap[requestId] = callback;	
		//console.log("Type: " + requestType+ " Registering listener for: " + JSON.stringify(repeatingCallbackMap) + repeatingCallbackMap.requestType);
	};
	
	this.unRegisterCallback = function(requestId, callback){
		delete repeatingCallbackMap[requestId];	
	};
	
	var connectInterval = setInterval(function(){
		try{	
			console.log("connecting to 5553");
			client.connect(55553, HOST, function() {
				debug_tcp('CONNECTED TO: ' + HOST + ':' + 55553); 
				clearInterval(connectInterval);
			});
			
		}
		catch(err){
			debug_tcp("TCPerror in Data client port...outer error");
			debug_tcp(JSON.stringify(err));
		}
		
	}, 1000);
		
	client.on('connect', function(){
		connectEstablished = true;
		console.log("Get port requester connected to 55553");
	});	
		
	client.on('error', function(e) {
		debug_tcp("TCP on error in Data client port");
		debug_tcp(JSON.stringify(e));
	});	

	// Add a 'data' event handler for the client socket
	// data is what the server sent to this socket
	
	client.on('data', function(data) {
		//console.log("received: " + data.toString());
		var jsonArray = parseJSONObjects(data);
		for (var x = 0; x < jsonArray.length; x++){
			var jsonData = jsonArray[x];
			//find the callback to send the response back to
			var requestId = jsonData.requestId; 
			var callback = repeatingCallbackMap[requestId];
			if (callback == null){
				return;
			}
			
		    callback(jsonData.responseProps);
			//console.log("deleting " + requestId);
			
		}
	});
	
	
	function parseJSONObjects(data){
		var resultArray = [] 
		var objectStrings = data.toString().split('\0');
		
		//console.log(objectStrings.length);
	  
	    for (var x=0; x < objectStrings.length; x++) {
			var jsonObj = {};
			try{
				if (objectStrings[x].length > 0){
					debug_tcp("parsing " + objectStrings[x]);
		        	jsonObj = JSON.parse(objectStrings[x]);
				}
			}
			catch(error){
				console.log("=================================================================");
				console.log("ERIK, I got a parsing error trying to parse what came back from the TCP Port: " );
				console.log(objectStrings[x]);
				
				console.log("=================================================================");
			}
			if (jsonObj){
            	resultArray.push(jsonObj);
			}
	    }
	    
  		return resultArray;
	}
	
	// Add a 'close' event handler for the client socket
	client.on('close', function() {
	    debug_tcp('TCP Get values connection  closed');
	});
	
	/**
	 * Send a message. 
	 * requestType allows you t
	 */
	this.send = function(requestType, fieldList){
		if (fieldList == null){
			return;
		}
		//find the callback for this request type
		var callback = repeatingCallbackMap[requestType];
		if (callback == null){
			console.log("No callback method found for request type");
			return;
		}
		
		//add the request type to the message
		fieldList['requestId'] = requestType;
		
		var request = {
			requestProps: fieldList,
			requestId: requestType
		}
		var messageBuffer = new Buffer(JSON.stringify(request));
		try{
			//console.log("client sending");
			client.write(messageBuffer); 
			//console.log("client sent");
		}
		catch(err){
			debug_tcp("TCP error in Data client port...outer error");
			debug_tcp(JSON.stringify(err));
		}
	
	};	
	
	this.close = function(){
		client.destroy();
	}
	
} 





exports.LLPortSetterTCPClass = function LLPortDataTCPSet(){
	
	var client_set = new net.Socket();
	var connectEstablished = false;
	
	this.isConnectEstablished = function(){
		return connectEstablished;
	}
	
	var connectInterval = setInterval(function(){
		try{		
			client_set.connect(55552, HOST, function() {
				debug_tcp('CONNECTED TO: ' + HOST + ':' + 55552); 
				clearInterval(connectInterval);
			});
			
		}
		catch(err){
			debug_tcp("TCP error in Data client set port...outer error");
			debug_tcp(JSON.stringify(err));
		}
	}, 1000);
		
	client_set.on('connect', function(){
		connectEstablished = true;
		console.log('Set values connected on 55552');
	});
		
	client_set.on('error', function(e) {
		debug_tcp("TCP on error in Data set client port");
		debug_tcp(JSON.stringify(e));
	});	

	
	// Add a 'close' event handler for the client socket
	client_set.on('close', function() {
	    debug_tcp('TCP Set values connection  closed');
	});
	
	/**
	 * Send a message. 
	 * requestType allows you t
	 */
	this.set = function(jsonObj){
		
	
		
		var request = {
			setProps: jsonObj
		}
		var messageBuffer = new Buffer(JSON.stringify(request));
		try{
			debug_tcp("client sending");
			client_set.write(messageBuffer); 
			debug_tcp("client sent");
		}
		catch(err){
			debug_tcp("TCP error in Data client port...outer error");
			debug_tcp(JSON.stringify(err));
		}
	
	};	
	
	this.close = function(){
		client_set.destroy();
	}
	
} 

exports.JensClass= function JensPort(port){

	var socket;
    var connectEstablished = false;
	
	this.isConnectEstablished = function(){
		return connectEstablished;
	}
	
	this.start = function(/*int*/ freqMillis, dataCallback){
		socket = dgram.createSocket("udp4");
		var buffer = new Buffer(1);
		var int8View = new Int8Array(buffer);
		buffer[0] = freqMillis;
		
		var connectInterval = setInterval(function(){
			socket.send(buffer, 0, 1, port, HOST, function(err, bytes) {
				if (err) {
					console.log("UDP error in scan Jens port");
					console.log(JSON.stringify(err));
					clearInterval(connectInterval);
				}
			});
		}, 250);
		
		socket.on('listening', function(){
			connectEstablished = true;
			console.log('Jens is on the attack');
		});
		
		socket.on('message', function (message, remote) {
		//console.log('received message' + message.length);
			dataCallback(message);
			
			
		});
		
		socket.on('error', function(e) {
			console.log("UDP on error in Jens client port");
			console.log(JSON.stringify(e));
		});
		
		
	};

}


exports.TCPListener= function TCPPort(tcpport){
	console.log("in status");
	var client = null;
	this.start = function( dataCallback){
		console.log("in start");
		
		var startStatusInterval = setInterval(function(){
			client = net.connect(tcpport, HOST, function() { //'connect' listener
				clearInterval(startStatusInterval);
			});
			client.on('data', function(data) {
				dataCallback(data);
		
			});
			client.on('end', function() {
				console.log('disconnected from server');
			});
			client.on('error', function() {
				console.log('error from server: status port might not be ready');
			});	
		}, 1000);
		
		
		
	};
	
	this.stop = function(){
		
		client.destroy();
		console.log('status disconneted');
	};
	
}