/**
 * New node file
 */

var ref = require('ref');
var ffi = require('ffi');
var refArray = require('ref-array');

var CharArrayType = refArray('char');
var FloatArrayType = refArray('float');

var responseBuffer = new CharArrayType(4096);
var dataResponseBuffer = new CharArrayType(4096);
var floatArrayBuffer = new FloatArrayType(256);

var currentData;

exports.getCurrentData = function(){
	return currentData;
};

var NULL_CHAR = '\0';
var JSON_BUF_LEN = 2045

var laserlux_lib = ffi.Library('libLaserlux',{
		'lib_set_value':['int', ['string']],
		'lib_get_value':['int', ['string', CharArrayType]]
	
});



function asycHandler(err, res){
	if (err) throw err;

};



exports.get_values = function(field_list){

	var request = {
			requestProps: field_list
	}
	
	var jsonReq = JSON.stringify(request);
	//console.log("liblaserlux.js get_values request " + jsonReq);
	try{
		var start = new Date();
		returnCode = laserlux_lib.lib_get_value(jsonReq, responseBuffer);
		console.log(JSON.stringify(field_list) + " lib_get_value took: " + (new Date() - start).toString());
		
		start = new Date();
		var response = charArrayToString(responseBuffer);
		console.log("charArrraytostring:  " + (new Date() - start).toString());
		return JSON.parse(response);
	}
	catch(e){
		console.log("Caught Exception in getValues return");
		console.log(e);
	}
	
}

exports.get_values_char_array = function(field_list){

	var request = {
			requestProps: field_list
	}
	
	var jsonReq = JSON.stringify(request);
	//console.log("liblaserlux.js get_values request " + jsonReq);
	try{
		var start = new Date();
		returnCode = laserlux_lib.lib_get_value(jsonReq, responseBuffer);
		console.log(JSON.stringify(field_list) + " get_values_char_array took: " + (new Date() - start).toString());
		var size = getCharArraySize(responseBuffer);
		var returnBuffer = new Buffer(size);
		start = new Date();
		trimCharArray(responseBuffer, returnBuffer);

		console.log("trimCharArray:  " + (new Date() - start).toString());
		return returnBuffer;
	}
	catch(e){
		console.log("Caught Exception in get_values_char_array return");
		console.log(e);
	}
	
}

exports.set_values = function(field_list){
	
	
	var request = {
			setProps: field_list
	}
	console.log(field_list);
	console.log(request);
	console.log("request: " + request);
	var jsonReq = JSON.stringify(request);
	console.log(jsonReq);
	try{
		returnCode = laserlux_lib.lib_set_value(jsonReq);
	}
	catch(e){
		console.log("Caught Exception in setValues return");
		console.log(e);
	}
	
}




function asycHandler(err, res){
	if (err) throw err;

};


function getCharArraySize(charArray){
	for (var x = 0 ; x < charArray.length; x++){
		var character = charArray[x];
		if (character == 0){
			return x
		}
	}
	return x;
	
}

function stringToCharArray(str, charArray){
	console.log(charArray.length);
	for (var x = 0 ; x < str.length; x++){
		var character = str.charAt(x);
		charArray[x] = character;
	}
	charArray[str.length + 1] = NULL_CHAR;
	
}

function trimCharArray(sourceBuffer, returnBuffer){
	
	for (var x = 0; x<sourceBuffer.length;x++){
		var character = sourceBuffer[x];
		returnBuffer[x] = character;
		
	}
	
	return returnArray;
	
}

function charArrayToString(array){
	
//	var string = "";
//	
//	for (var x = 0; x<array.length;x++){
//		var character = String.fromCharCode(array[x]);
//		if (character == NULL_CHAR){
//			break;
//		}
//		string += character;
//
//	}
//	return string;
//	var string = String.fromCharCode.apply(String, array);
	console.log(string);
	return string;
	
}

function floatToString(num, places){
	
	var numStr = num.toString();
	var decimalAt = numStr.indexOf(".");
	return numStr.substr(0, decimalAt + places + 1);
}






exports.start_daemon = function(){
	var requestProps = {
			SFRD: 1
	}
	this.set_values(requestProps)
}

var realtimeProps = ['ROSC'];

//setInterval(function(){
	//var realtime = get_values(realtimeProps);
//	get_data2();

//}, 30);



