/*
 * color_graph.js
 */

var CIE_HEIGHT = 0.9;
var CIE_WIDTH = 0.8;
var POINT_LINE = 3;
var canvasHeight = 185;
var canvasWidth = 160;

var boxes = [];
// boxPoints:
// 40 values defining coordinates of 5 color boxes [box0_x0,box0_y0,box0_x1,box0_y1,box0_x2,box0_y2,box0_x3,box0_y3,box1_x0,box1_y0,box1_x1,box1_y1,box1_x2,box1_y2,box1_x3,box1_y3,box2_x0,box2_y0,box2_x1,box2_y1,box2_x2,box2_y2,box2_x3,box2_y3,box3_x0,box3_y0,box3_x1,box3_y1,box3_x2,box3_y2,box3_x3,box3_y3,box4_x0,box4_y0,box4_x1,box4_y1,box4_x2,box4_y2,box4_x3,box4_y3]

var ColorChart = function(canvasElem, boxPoints) {
	parseBoxPoints(boxPoints);
	this.sketchProc = function(processing) {
		processing.frameRate(15);
		processing.textFont(processing.createFont("Serif", 9));
		processing.textAlign(processing.LEFT);
		processing.draw = function(xSize) {
			// erase background
			processing.background(51);
			function drawBoxes() {
				for (var x = 0; x < boxes.length; x++) {
					var boxPoints = boxes[x];
					processing.noFill();
					processing.beginShape();
					if (x == 0) {
						processing.stroke(255, 255, 255);
					} else if (x == 1) {
						processing.stroke(255, 255, 0);
					} else {
						processing.stroke(100, 100, 200);
					}
					processing.strokeWeight(1);
					processing.quad(boxPoints[0], boxPoints[1], boxPoints[2], boxPoints[3], boxPoints[4], boxPoints[5], boxPoints[6], boxPoints[7]);
				}
			}
			function drawDots() {
				if (points) {
					// SNUM+21 277 cie_x_coord of left stripe 0-.8
					// SNUM+22 278 cie_y coord of left stripe 0-.8
					// SNUM+23 279 cie_x_coord of right stripe 0-.8
					// SNUM+24 280 cie_y_coord of right stripe 0-.8
					processing.stroke(255, 255, 255);
					// processing.text("x", xPos(points[SNUM+21]), yPos(points[SNUM+22]));
					// processing.text("+", xPos(points[SNUM+23]), yPos(points[SNUM+24]));
					// draw left +
					// processing.ellipse(xPos(points[SNUM+21]), yPos(points[SNUM+22]), 1, 1);
					processing.line(xPos(points[SNUM + 21]) - POINT_LINE, yPos(points[SNUM + 22]), xPos(points[SNUM + 21]) + POINT_LINE, yPos(points[SNUM + 22]));
					processing.line(xPos(points[SNUM + 21]), yPos(points[SNUM + 22]) - POINT_LINE, xPos(points[SNUM + 21]), yPos(points[SNUM + 22]) + POINT_LINE);
					// draw right x
					processing.line(xPos(points[SNUM + 23]) - POINT_LINE, yPos(points[SNUM + 24]) - POINT_LINE, xPos(points[SNUM + 23]) + POINT_LINE, yPos(points[SNUM + 24]) + POINT_LINE);
					processing.line(xPos(points[SNUM + 23]) + POINT_LINE, yPos(points[SNUM + 24]) - POINT_LINE, xPos(points[SNUM + 23]) - POINT_LINE, yPos(points[SNUM + 24]) + POINT_LINE);
				}
			}
			drawBoxes();
			drawDots();
		}
		processing.size(160, 160);
	}
	// attaching the sketchProc function to the canvas
	var p = new Processing(canvasElem, this.sketchProc);
	// p.exit(); to detach it
}

function xPos(cie_x) {
	return (cie_x / CIE_WIDTH) * canvasWidth;
}
function yPos(cie_y) {
	return canvasHeight - ((cie_y / CIE_HEIGHT) * canvasHeight);
}
function makeBoxPoints(boxPoints, x) {
	return [ xPos(boxPoints[x * 8 + 0]), yPos(boxPoints[x * 8 + 1]), xPos(boxPoints[x * 8 + 2]), yPos(boxPoints[x * 8 + 3]), xPos(boxPoints[x * 8 + 4]), yPos(boxPoints[x * 8 + 5]), xPos(boxPoints[x * 8 + 6]), yPos(boxPoints[x * 8 + 7]) ];

}
function parseBoxPoints(boxPoints) {
	if (boxPoints == null) {
		return;
	}
	for (var x = 0; x < 5; x++) {
		boxes[x] = makeBoxPoints(boxPoints, x);
	}
}