//0	0	1st y-value of plotted data	
//1	1	2nd y-value of plotted data	
//SNUM-2	254	2nd to last y-value of plotted data	
//SNUM-1	255	Last y-value of plotted data	
//SNUM	256	X1 Coordinate of Left Value Bar	Value Bar Is a Line Plotted from (X1,Y1 to X2,Y2)  ... and x is the index
//SNUM+1	257	Y1 Coordinate of Left Value Bar	
//SNUM+2	258	X2 Coordinate of Left Value Bar	
//SNUM+3	259	Y2 Coordinate of Left Value Bar	
//SNUM+4	260	Red Component of Left Value_bar	    0-255.0
//SNUM+5	261	Green Component of Left Value_bar   0-255.0
//SNUM+6	262	Blue Component of Left Value_bar	0-255.0
//SNUM+7	263	X-value of Left Stripe-Left Boundary Stripeline Indicator	"Left Stripeline is a Vertical Line Plotted at the X value from top to bottom
//SNUM+8	264	"X-value of Left Stripe-Right Boundary Stripeline Indicator	"Right Stripeline is a Vertical Line Plotted at the X value from top to bottom
//SNUM+9	265	X1 Coordinate of Right Value Bar	Value Bar Is a Line Plotted from (X1,Y1 to X2,Y2)  ... and x is the index
//SNUM+10	266	Y1 Coordinate of Right Value Bar	
//SNUM+11	267	X2 Coordinate of Right Value Bar	
//SNUM+12	268	Y2 Coordinate of Right Value Bar	
//SNUM+13	269	Red Component of Right Value_bar	0-255.0
//SNUM+14	270	Green Component of Right Value_bar  0-255.0
//SNUM+15	271	Blue Component of Right Value_bar	0-255.0
//SNUM+16	272	X-value of Right Stripe-Left Boundary Stripeline Indicator	"Left Stripeline is a Vertical Line Plotted at the X value from top to bottom
//SNUM+17	273	"X-value of Right Stripe-Right Boundary Stripeline Indicator Right Stripeline is a Vertical Line Plotted at the X value from top to bottom
//SNUM+18	274	"Red Component of plotted_data_line	0-255.0
//SNUM+19	275	Green Component of plotted_data_line	"0-255.0
//SNUM+20	276	"Blue Component of plotted_data_line   0-255.0

//var VALUE_UPPER_LIMIT=1000;
var TOTAL_WIDTH = 355;
var TOTAL_HEIGHT = 200; // was 250

// var POINT_WIDTH=TOTAL_WIDTH / POINTS_PER_COLOR;
var POINT_WIDTH = 1;
// Simple way to attach js code to the canvas is by using a function
var sinusoidalXLocArray = {};

var ScanGraph = function(canvasElem, xSize) {
    this.sketchProc = function(processing) {
	var POINTS_PER_COLOR = 256;
	if (xSize) {
	    POINTS_PER_COLOR = xSize;
	}

	populateSinXArray();
	// poll for an RGXV value until it's available
	function populateSinXArray() {
	    var rgxvInterval = setInterval(function() {
		getFields([ 'RGXV' ],
			function(data) {
			    if (data.RGXV !== undefined) {
				for (var x = 0; x < data.RGXV.length; x++) {
				    sinusoidalXLocArray[x] = data.RGXV[x]
					    * TOTAL_WIDTH;
				}
				clearInterval(rgxvInterval);
			    }
			});
	    }, 300);
	}

	processing.frameRate(15);
	processing.textFont(processing.createFont("Serif", 9));
	processing.textAlign(processing.LEFT);
	processing.draw = function(xSize) {
	    // erase background
	    processing.background(51);
	    function drawPoints() {
		if (points == null) {
		    return;
		}
		processing.noFill();
		processing.beginShape();
		processing.stroke(points[SNUM + 18], points[SNUM + 19],
			points[SNUM + 20]);
		processing.strokeWeight(2);
		for (var x = 0; x < POINTS_PER_COLOR; x++) {
		    // processing.point(x, color_points[x]);
		    var ellipse_x = sinusoidalXLocArray[x];
		    // Erik keeps changing which direction the graph should be
		    // in.
		    // var ellipse_y= TOTAL_HEIGHT - ((points[POINTS_PER_COLOR -
		    // x - 1] / y_axis_max ) * TOTAL_HEIGHT);
		    var ellipse_y = yRelativeToHeight(points[x]); // TOTAL_HEIGHT
								    // -
								    // ((points[x]
								    // /
								    // y_axis_max
								    // ) *
								    // TOTAL_HEIGHT);
		    // var rpm_height = TOTAL_HEIGHT - ((rpm / y_axis_max ) *
		    // TOTAL_HEIGHT);
		    processing.vertex(ellipse_x, ellipse_y);
		}
		processing.endShape();
	    }

	    function drawRPM() {
		if (rpm == null) {
		    return;
		}
		processing.noFill();
		processing.beginShape();
		for (var x = 0; x < POINTS_PER_COLOR; x++) {
		    var ellipse_x = (TOTAL_WIDTH / POINTS_PER_COLOR) * x;
		    var rpm_height = TOTAL_HEIGHT
			    - ((rpm / y_axis_max) * TOTAL_HEIGHT);
		    processing.stroke(200, 128, 0);
		    processing.ellipse(ellipse_x, rpm_height, POINT_WIDTH,
			    POINT_WIDTH);
		}
		processing.endShape();
	    }

	    function drawValueBarLeft() {
		if (points == null) {
		    return;
		}
		// var x1 = sinusoidalXLocArray[points[SNUM]];
		var x1 = interpolated_val(points[SNUM]);
		var y1 = yRelativeToHeight(points[SNUM + 1]);
		// var x2 = sinusoidalXLocArray[points[SNUM + 2]];
		var x2 = interpolated_val(points[SNUM + 2]);
		var y2 = yRelativeToHeight(points[SNUM + 3]);
		processing.beginShape();
		processing.strokeWeight(3);
		processing.stroke(points[SNUM + 4], points[SNUM + 5],
			points[SNUM + 6]);
		processing.line(x1, y1, x2, y2);
		processing.endShape();
		// console.log("LeftBar=" + y1.toString() + " rgb(" +
		// points[SNUM + 4].toString() + "," + points[SNUM +
		// 5].toString() + "," + points[SNUM + 6].toString() + ")");
	    }

	    function drawValueBarRight() {
		if (points == null) {
		    return;
		}
		// var x1 = sinusoidalXLocArray[points[SNUM + 9]];
		var x1 = interpolated_val(points[SNUM + 9]);
		var y1 = yRelativeToHeight(points[SNUM + 10]);
		// var x2 = sinusoidalXLocArray[points[SNUM + 11]];
		var x2 = interpolated_val(points[SNUM + 11]);
		var y2 = yRelativeToHeight(points[SNUM + 12]);
		processing.beginShape();
		processing.strokeWeight(3);
		processing.stroke(points[SNUM + 13], points[SNUM + 14],
			points[SNUM + 15]);
		processing.line(x1, y1, x2, y2);
		processing.endShape();
	    }

	    function drawYUnits() {
		processing.fill(255, 255, 0);
		var interval = y_axis_max / 16; // show 16 numbers
		interval = Math.ceil(interval / 100) * 100 // rount to the
							    // nearest 100
		for (var x = 0; x < y_axis_max; x = x + interval) {
		    var location = TOTAL_HEIGHT
			    - ((x / y_axis_max) * TOTAL_HEIGHT);
		    processing.text(x, 0, location);
		}
	    }

	    function drawStripeLinesLeft() {
		if (points == null) {
		    return;
		}
		// var leftX = sinusoidalXLocArray[points[SNUM + 7]];
		var leftX = interpolated_val(points[SNUM + 7]);
		// var rightX = sinusoidalXLocArray[points[SNUM + 8]];
		var rightX = interpolated_val(points[SNUM + 8]);
		processing.strokeWeight(1);
		processing.stroke(points[SNUM + 4], points[SNUM + 5],
			points[SNUM + 6]);
		dashedVerticalLine(leftX, 0, TOTAL_HEIGHT, 5);
		dashedVerticalLine(rightX, 0, TOTAL_HEIGHT, 5);
	    }

	    function drawStripeLinesRight() {
		if (points == null) {
		    return;
		}
		// var leftX = sinusoidalXLocArray[points[SNUM + 16]];
		var leftX = interpolated_val(points[SNUM + 16]);
		// var rightX = sinusoidalXLocArray[points[SNUM + 17]];
		var rightX = interpolated_val(points[SNUM + 17]);
		processing.strokeWeight(1);
		processing.stroke(points[SNUM + 13], points[SNUM + 14],
			points[SNUM + 15]);
		dashedVerticalLine(leftX, 0, TOTAL_HEIGHT, 5);
		dashedVerticalLine(rightX, 0, TOTAL_HEIGHT, 5);
	    }

	    function drawRectangleLeft() {
		if (points == null) {
		    return;
		}
		// var leftX = sinusoidalXLocArray[points[SNUM + 7]];
		var leftX = interpolated_val(points[SNUM + 7]);
		// var rightX = sinusoidalXLocArray[points[SNUM + 8]];
		var rightX = interpolated_val(points[SNUM + 8]);
		var y1 = yRelativeToHeight(points[SNUM + 1]);
		processing.strokeWeight(0);
		processing.stroke(points[SNUM + 4], points[SNUM + 5],
			points[SNUM + 6], 0);
		processing.beginShape();
		processing.fill(points[SNUM + 4], points[SNUM + 5],
			points[SNUM + 6], 128);
		processing.rect(leftX, y1, rightX - leftX, y_axis_max);
		processing.endShape();
	    }

	    function drawRectangleRight() {
		if (points == null) {
		    return;
		}
		// var leftX = sinusoidalXLocArray[points[SNUM + 16]];
		var leftX = interpolated_val(points[SNUM + 16]);
		// var rightX = sinusoidalXLocArray[points[SNUM + 17]];
		var rightX = interpolated_val(points[SNUM + 17]);
		var y1 = yRelativeToHeight(points[SNUM + 10]);

		processing.strokeWeight(0);
		processing.stroke(points[SNUM + 13], points[SNUM + 14],
			points[SNUM + 15], 0);
		processing.beginShape();
		processing.fill(points[SNUM + 13], points[SNUM + 14],
			points[SNUM + 15], 128);
		processing.rect(leftX, y1, rightX - leftX, y_axis_max);
		processing.endShape();
	    }
	    drawPoints();
	    drawRPM();
	    drawYUnits();
	    drawValueBarLeft();
	    drawValueBarRight();
	    drawStripeLinesLeft();
	    drawStripeLinesRight();
	    drawRectangleLeft();
	    drawRectangleRight();
	};

	function dashedVerticalLine(x, y1, y2, spacing) {
	    processing.beginShape();
	    for (var i = 0; i < y2; i += spacing) {
		if (i % 2 == 0) {
		    // processing.beginShape();
		    processing.line(x, i, x, i + spacing);
		}
	    }
	    processing.endShape();
	}

	function interpolated_val(x_input) {
	    if (x_input >= (SNUM - 1)) {
		return sinusoidalXLocArray[SNUM - 1];
	    } else {
		var x_diff = sinusoidalXLocArray[Math.floor(x_input + 1)]
			- sinusoidalXLocArray[Math.floor(x_input)];
		var xmult = x_input - Math.floor(x_input);
		return sinusoidalXLocArray[Math.floor(x_input)]
			+ (xmult * x_diff);
	    }
	}

	function yRelativeToHeight(rawY) {
	    return TOTAL_HEIGHT - ((rawY / y_axis_max) * TOTAL_HEIGHT);
	}
	processing.size(TOTAL_WIDTH, TOTAL_HEIGHT);
    }

    // attaching the sketchProc function to the canvas
    var p = new Processing(canvasElem, this.sketchProc);
    // p.exit(); to detach it
}
