/**
 * Module dependencies.
 */

var express = require('express')
  , routes = require('./routes')
  , http = require('http')
  , path = require('path')
  , spawn = require('child_process').spawn
  , child_process = require('child_process')
  , debug = require('debug')('laserlux')
  , laserlux_port_listener = require('./laserlux_port.js');

//laserlux.start_daemon();

var HOME_EMIT_FREQUENCY_MILLI =  200;
var JENS_FREQUENCY_MILLI = 40;
var SYSTEM_MESSAGE_FREQUENCY_MILLI = 1000;

var field_list_shortcuts = {};
//Values that will be emitted to the home page regularly
field_list_shortcuts['settings_repeat'] = ['SCQ0', 'SCQ1', 'SCDT', 'SCSV', 'SVIR', 'SCPF', 'SNCH'];
field_list_shortcuts['home_repeat'] = ['RLCI', 'RRCI', 'RCBO', 'GDAT', 'GERR','GLAT', 'GODO', 'GROD', 'GSPD', 'GTIM', 'GALT', 'GLON', 'GFIX', 'GOFF', 'GSAT',
                      'EHUM', 'ETMP', 'SLAL', 'SLLS', 'RPFC',
                      'ACN0', 'ACN1', 'ACN2', 'ACN3', 'ACN4', 'ACN5', 'ACN6', 'ACN7', 'ACN8', 'ACN9', 
                      'AST0', 'AST1', 'AST2', 'AST3' , 'AST4' , 'AST5', 
                      'RMVP', 'ROSC',  'RPMC', 'RLST', 'RPLC', 'RLM0', 'RLZC', 'RLA0', 'RLIR', 'RLF0', 'SMEM', 'SDFW', 'SCPU', 'SDQS',
                      'SDSI', 'VIDP', 'RYAR',  'RPML', 'RRZC', 'RRM0', 'RNN0', 'RRA0', 'RRIR', 'RRST', 'RRF0', 'RPRC',
					  'ACM0', 'ACM1', 'ACM2', 'ACM3', 'ACM4', 'ACM5', 'ACM6', 'ACM7','ACM8', 'ACM9', 'RSCD',
					  'RYMX', 'SNUM', 'RCSO', 'RCCO', 'GSTR', 'RDSI', 'GDIR', 'RDSC', 'RDSF',
					  'ACL0', 'ACL1', 'ACL2', 'ACL3', 'ACL4', 'ACL5', 'ACL6', 'ACL7','ACL8', 'ACL9' ];

debug("sarting up");
// Create a laserlux process
var spawn = require('child_process').spawn;

var child = null;
try{
	var child = spawn('/home/debian/laserlux');
}
catch(e){
	console.log("Exception launching laserlux executable. " + JSON.stringify(e));
}

// Listen for stdout data
child.stdout.on('data', function (data) {
    console.log("Got data from laserlux: " + data);
});

// Listen for an exit event:
child.on('exit', function (exitCode) {
    console.log("lasrlux exited with code: " + exitCode);
});

console.log('starting laserlux complete');

var JENS_SEND = new Buffer("0");
var app = require('express')();
var server = require('http').Server(app);
var io = require('socket.io')(server);
// Configuration
var value_setter = new laserlux_port_listener.LLPortSetterTCPClass();
var get_port_requester = new laserlux_port_listener.LLPortRequesterTCPClass();
var ll_library_version = "";

exports.get_library_version = function(){
	return ll_library_version;
};

app.configure(function(){
  app.set('port', process.env.PORT || 80);
  app.set('views', __dirname + '/views');
  app.set('view engine', 'jade');
  app.use(express.favicon(__dirname + "/public/img/favicon.ico"));
  app.use(express.logger('dev'));
  app.use(express.bodyParser());
  app.use(express.methodOverride());
  app.use(express.cookieParser());
  app.use(express.session({ secret: 'your secret here' }));
  app.use(app.router);
  app.use(express.static(path.join(__dirname, 'public')));
});

app.configure('development', function(){
  app.use(express.errorHandler({ dumpExceptions: true, showStack: true }));
});

app.configure('production', function(){
  app.use(express.errorHandler());
});

// Routes
var auth = express.basicAuth(function(user, pass) {
 return user === 'admin' && pass === 'lanternerouge';
});

app.get('/', routes.index);
app.get('/home', routes.home);
app.get('/live', routes.live);
app.get('/settings', routes.settings);
app.get('/settings_eng', auth, routes.settings_eng);
app.get('/status', routes.status);

app.get('/getValues', function(request, response){
	var request_fields = {};
	var random = Math.random();
	console.log(request.query);
	//if this was a shortcut field set, go find the fields in  field_list_shortcuts
	var field_set_name = request.query.field_set_name;
	if (field_set_name != null){
		request_fields = field_list_shortcuts[field_set_name];
	} 
	else{
		request_fields = JSON.parse(request.query.fields);
	}
	var requestId = 'getvalues' + random;
	get_port_requester.registerCallBack(requestId , function(llresponse){		
		response.json(llresponse);
		get_port_requester.unRegisterCallback(requestId);
		return;
	});
	get_port_requester.send(requestId, request_fields);
});

app.post('/post', function(request, response) {
	console.log("Setting: " + JSON.stringify(request.body));
	value_setter.set(request.body);
	response.send('success');
	
});

server.listen(app.get('port'), function(){
	  console.log('Express server listening on port ' + app.get('port'));
}); 


////////////////////////////////////////////////////////////////////////
// Socket Value Provider BEGIN
////////////////////////////////////////////////////////////////////////
function SocketValueProvider(ioNamespaceSocketName, emitKey, requestValueArray, refreshRateMillis){
	debug("Creating value provider for " + ioNamespaceSocketName);
	//socketIO namespace for connected clients. Use a namespace
	//so that only connected home pages, not other pages, get home page values
	var ioNamespeceSocket = io.of(ioNamespaceSocketName);
	//counter of current connected clients
	var connectedClientCnt = 0;
	//create a conection on the socketIO namespace
	ioNamespeceSocket.on('connection', function (socket) {	
		connectedClientCnt++;
		console.log(ioNamespaceSocketName + " connected");
		socket.on('disconnect', function(){ 
			connectedClientCnt--;
		});
	});
	//field_list_shortcuts has the home page field list under the key 'home_repeat'
	//This callback sends values to home clients
	get_port_requester.registerCallBack(ioNamespaceSocketName, function(llresponse){
		//console.log("callback with values");
		ioNamespeceSocket.emit(emitKey, llresponse);
	});
	//create an interval that runs all the time, but only sends data if there are
	//connected clients. It would be nice to be able to ask the socketIO namespace
	//if there are connected clients, but we can't figure out how, so we're 
	//keeping the counter on our own.
	console.log("setting interval for " + ioNamespaceSocketName + " to " + refreshRateMillis);
	setInterval(function(){
		if (connectedClientCnt > 0){
			// console.log(ioNamespaceSocketName + " delivery");
			get_port_requester.send(ioNamespaceSocketName, requestValueArray);
		}
	}, refreshRateMillis);
}; 

////////////////////////////////////////////////////////////////////////
// Socket Value Provider END
////////////////////////////////////////////////////////////////////////

//setup home page value providing
var homePageValueProvider = new SocketValueProvider('/home', 'homeValues', field_list_shortcuts['home_repeat'], HOME_EMIT_FREQUENCY_MILLI );
var settingsPageValueProvider = new SocketValueProvider('/settings', 'settingsValues', field_list_shortcuts['settings_repeat'], HOME_EMIT_FREQUENCY_MILLI );
var systemMessagesPageValueProvider = new SocketValueProvider('/sys_msg', 'systemMessages', ['SMSG'], SYSTEM_MESSAGE_FREQUENCY_MILLI);
var statusPageListener = new laserlux_port_listener.TCPListener(44444);
var statusIONamespace = io.of("/status");
statusIONamespace.on('connection', function(socket){
	statusPageListener.start(function(data){
		statusIONamespace.emit("statusData", data);
	});
	socket.on('disconnect', function(){
		statusPageListener.stop();
	});
});

var jensIONamespace = io.of("/graph");
var jens = new laserlux_port_listener.JensClass(55554);
jens.start(JENS_FREQUENCY_MILLI, function(data){
	jensIONamespace.emit('jens', data);
});	

process.stdin.resume();

process.on('SIGINT', function() {
  console.log('Got SIGINT.  Shutting down tcp ports');
  value_setter.set({"SSHT": 1});
  console.log("SENT {\"SSHT\": 1}");
  get_port_requester.close();
  value_setter.close();
  process.exit();
});

process.on('uncaughtException', function(err) {
  console.log('Caught exception: ' + err);
});

//get laserlux binary version
get_port_requester.registerCallBack("SSVE_req",  function(llresponse){
		console.log("sending SSVE" + JSON.stringify(llresponse));
		ll_library_version = llresponse.SSVE;
		console.log("Rolling with library version: " + ll_library_version);
});

var ssveInterval = setInterval(function(){
	//console.log('trying to get ssve');
	try{
		if (get_port_requester.isConnectEstablished()){
			get_port_requester.send("SSVE_req", ["SSVE"]);
		}
	}
	catch(e){
		//console.log('trying ssve but port not readay');
	}
	if (ll_library_version != ""){
		clearInterval(ssveInterval);
	}
}, 250);




