/*
 * process.h
 *
 *  Created on: Jul 14, 2014
 *      Author: erik
 */

#ifndef PROCESS_H_
#define PROCESS_H_

// prototypes
extern int run_laserlux_daemon();									// starts realtime processing
extern int set_simulate_hardware(int hardware, int simulate);		// before starting the daemon, set the simulation hardware options (0=normal, 1=simulate)
extern int get_gps_latitude(char *sentence);
extern int get_gps_longitude(char *sentence);
extern int get_gps_speed(char *sentence);
extern int get_gps_altitude(char *sentence);
extern int get_gps_date(char *sentence);
extern int get_gps_time(char *sentence);
extern int get_gps_position_error(char *sentence);
extern int get_gps_number_satellites(char *sentence);
extern int get_gps_fix_type(char *sentence);
extern int get_gps_odometer_distance(char *sentence);
extern int get_gps_odometer_accuracy(char *sentence);
extern float leveling_get_height();									// returns the height of the laserlux
extern float leveling_get_angle();									// returns the for-aft angle of the laserlux based on proximity sensors
extern int get_scan_values(int color, float *vals);					// (for color red=0,green=1,blue=2) values is 128 position arra of floats
extern float get_outside_temperature();								// returns temperature in degrees C
extern float get_outside_humidity();								// returns relative humidity
extern int set_laser_temperature(float);							// sets the temperature of the laser block
extern float get_laser_temperature();								// gets the temperature of the laser block
extern int gps_reset_odometer_lib();								// resets the gps odometer

// various defines
#define LEVELING_HARDWARE 1
#define GPS_HARDWARE 2
#define LASERBEAM_HARDWARE 3

#endif /* PROCESS_H_ */
