/*
/*
 * laserlux_client.js
 */
var points;
var y_axis_max;
var rpm;
var SNUM;

// var RGXV;
var NULL_CHAR = '\0';
var laserluxNS = {
	name : "laserluxNS",
	description : "namespace for Gamma-Scientific Laserlux_G7",
	version : '1.0'
};
laserluxNS.lastUpdateDttm = new Date();
laserluxNS.connected = true;

// initialize to defaults
var myTranslatedText = {
	txtHome : "Home",
	txtError : "Error",
	txtOK : "OK",
	txtWhite : "White",
	txtYellow : "Yellow",
	txtUp : "Up",
	txtDown : "Down",
	txtAuto : "Auto",
	txtStopped : "Stopped",
	txtPaused : "Paused",
	txtRecording : "Recording",
	txtLive : "Live",
	txtSettings : "Settings",
	txtStatus : "Status",
	txtEngSettings : "Engineering Settings"
};
var radioCtrls = [ {
	tagname : "RPFC",
	txtOn : "txtYellow",
	txtOff : "txtWhite"
}, {
	tagname : "GDIR",
	txtOn : "txtUp",
	txtOff : "txtDown"
}, {
	tagname : "SLAL",
	txtOn : "txtAuto",
	txtOff : "txtHome"
} ];
var myTextDecoder = null;
if ('TextDecoder' in window) {
	myTextDecoder = new TextDecoder("utf-8");
}

function setInnerHTML(id, txt) {
	var obj = document.getElementById(id);
	if (obj) {
		obj.innerHTML = txt;
	}
}

function getFieldsError(data, textStatus) {
	console.log("getFieldsError fail: data=" + data.toString());
	console.log("getFieldsError fail: textStatus=" + textStatus);
}

function getFields(fields, callback) {
	jQuery.ajax({
		url : "getValues",
		type : "GET",
		data : "fields=" + JSON.stringify(fields),
		dataType : "json",
		contentType : "application/json; charset=utf-8",
		success : function(data) {
			console.log("getFields(" + fields + ") request success");
			callback(data);
		},
		error : function(data) {
			var textStatus = "getFields(" + fields + ") request fail: " + data;
			console.log(textStatus);
			getFieldsError(data, textStatus);
		}
	});
}

function getValues(params, callback) {
	jQuery.ajax({
		url : 'getValues',
		type : "GET",
		data : params.data,
		dataType : "json",
		contentType : "application/json; charset=utf-8",
		success : function(data) {
			console.log("getValues(" + params.data + ") request success: " + JSON.stringify(data));
			callback(data);
		},
		error : function(data) {
			console.log("getValues(" + params.data + ") request fail: " + JSON.stringify(data));
		}
	});
}

function sendUpdates(fields) {
	var stringRequest = JSON.stringify(fields);
	jQuery.ajax({
		url : "post",
		type : "POST",
		data : stringRequest,
		dataType : "json",
		contentType : "application/json; charset=utf-8",
		success : function() {
			console.log("request success");
		}
	});
}

function containsFlag(flags, flag) {
	return (flags & flag) == flag;
}

function buildSystemMessageTag(message) {
	var alertLevel = 'info';
	switch (message.type) {// 0=info, 1=warning, 2=error
	case 0:
		alertLevel = 'info';
		break;
	case 1:
		alertLevel = 'warning';
		break;
	case 2:
		alertLevel = 'danger'; // bootstrap class for error
		break;
	}
	var messageTag = '<div class="alert alert-{type} fade in"">{messgageText}</div>';
	messageTag = messageTag.replace(/{type}/g, alertLevel);
	messageTag = messageTag.replace(/{messgageText}/g, message.value);
	return messageTag;
}

function field2Select(field) {
	var inputHTML = '<SELECT formid="foo" id="{key}" placeholder="" class="field-input form-control ll-settings" value="{value}">';
	if (field.options) {
		for (var ndx = 0; ndx < field.options.length; ndx++) {
			var opt = field.options[ndx];
			inputHTML += '<OPTION value="' + opt.value + '"';
			if (opt.value == field.value) {
				inputHTML += ' SELECTED="true"';
			}
			inputHTML += '>' + opt.value + '</OPTION>';
		}
	}
	inputHTML += '</SELECT>';
	return inputHTML;
}

function buildInputRow(row, field) {
	var rowContents = '<td class="halfwidth"><label class="settings_input_label" for="{key}">{description}</label></td><td class="halfwidth"><div class="form-inline"><div class="form-group">{input-control}</div>{help-button-html}</div></td>';
	rowContents = rowContents.replace(/{help-button-html}/g, buildHelpButton(field));
	var inputHML;
	if (field.input_type == 'text') {
		inputHTML = '<input id="{key}" type="text" class="field-input form-control ll-settings" value="{value}">';
	} else if (field.input_type == 'number') {
		inputHTML = '<input formid="foo" id="{key}" placeholder="" class="field-input form-control ll-settings" type="number" min="{min}" max="{max}" step="{step}"';
		if (typeof field.decimals != "undefined") {
			inputHTML += ' decimals="' + field.decimals.toString() + '"';
			inputHTML += ' value="' + field.value.toFixed(field.decimals) + '">';
		} else {
			inputHTML += ' value="{value}">';
		}
		inputHTML = inputHTML.replace(/{min}/g, field.min);
		inputHTML = inputHTML.replace(/{max}/g, field.max);
		inputHTML = inputHTML.replace(/{step}/g, field.step);
	} else if (field.input_type == 'select') {
		inputHTML = field2Select(field);
	} else if (field.input_type == 'radio') {
		inputHTML = "<ul class='input-radio-list'>";
		for (var ndx = field.min; ndx <= field.max; ndx += field.step) {
			inputHTML += "<li class='radio-item settings_input_label'>";
			inputHTML += "<input type='radio' name='{key}' value='" + ndx.toString() + "' class='input-radio-input field-input '";
			if (ndx == field.value)
				inputHTML += " checked";
			inputHTML += ">";
			var description = field.help;
			description = description.substr(description.indexOf(ndx.toString()));
			var eos = description.indexOf(",");
			if (eos == -1) {
				eos = description.indexOf(".");
			}
			if (0 < eos) {
				description = description.substr(0, eos);
			}
			inputHTML += description;
			inputHTML += "</li>"
		}
		inputHTML += "</ul>";
	}
	rowContents = rowContents.replace(/{input-control}/g, inputHTML);
	// settings common to all types of controls
	rowContents = rowContents.replace(/{description}/g, makeDescription(field));
	rowContents = rowContents.replace(/{key}/g, field.key);
	rowContents = rowContents.replace(/{value}/g, field.value);
	row.append(rowContents);
	return rowContents;
}

function buildHelpButton(field) {
	var helpButton = '<button class="btn-help" type="button" data-container="body" data-toggle="popover" data-placement="right" title="{title}" data-content="{help_text}" class="btn btn-default"><span class="glyphicon glyphicon-question-sign"></span></button>';
	helpButton = helpButton.replace(/{title}/g, field.description);
	helpButton = helpButton.replace(/{help_text}/g, field.help);
	return helpButton;
}

function makeDescription(field) {
	var description = field.key + ": " + field.description;
	if (field.input_type != 'number')
		return description;
	var isExtended = field.min != undefined || field.default_value != undefined || field.max != undefined;
	if (isExtended) {
		description += " (";
	}
	if (field.min != undefined) {
		description += field.min;
	}
	if (field.default_value != undefined) {
		description += " | " + field.default_value;
	}
	if (field.max != undefined) {
		description += " | " + field.max;
	}
	if (isExtended) {
		description += ")";
	}
	return description;
}

function translateLabels(fields, callback) {
	if (fields) {
		for (var ndx = 0; ndx < fields.length; ndx++) {
			var field = fields[ndx];
			if (field.key && 0 < field.key.length) {
				if (0 == field.key.indexOf("txt")) {
					myTranslatedText[field.key] = field.value;
				} else {
					setInnerHTML(field.key, field.value);
				}
			}
		}
		translateTitleMenu();
		updateRadioCtrlLabels();
	}
	callback();
}

function translateTitleMenu() {
	if (window.location.pathname == "/live") {
		document.title = myTranslatedText.txtLive;
	} else if (window.location.pathname == "/settings") {
		document.title = myTranslatedText.txtSettings;
	} else if (window.location.pathname == "/settings_eng") {
		document.title = myTranslatedText.txtEngSettings;
	} else if (window.location.pathname == "/status") {
		document.title = myTranslatedText.txtStatus;
	}
	translateMenuItem("settings", myTranslatedText.txtSettings);
	translateMenuItem("live", myTranslatedText.txtLive);
}

function translateMenuItem(pagename, txt) {
	var anchor = document.getElementById("idMenu" + pagename);
	if (anchor) {
		anchor.text = txt;
	}
}

function updateRadioCtrlLabels() {
	for (var ndx = 0; ndx < radioCtrls.length; ndx++) {
		var ctrl = radioCtrls[ndx];
		if (ctrl) {
			setInnerHTML("lbl" + ctrl.tagname + "on", myTranslatedText[ctrl.txtOn]);
			setInnerHTML("lbl" + ctrl.tagname + "off", myTranslatedText[ctrl.txtOff]);
		}
	}
}

function findChildByClassname(elm, classname) {
	if (elm == null)
		return null;
	if (elm.childNodes) {
		for (var ndx = 0; ndx < elm.childNodes.length; ndx++) {
			var child = elm.childNodes[ndx];
			if (child.className && -1 < child.className.indexOf(classname))
				return child;
			var grandChild = findChildByClassname(child, classname);
			if (null != grandChild)
				return grandChild;
		}
	}
	return null;
}

function buildEngrSettingsTable(fields, callback) {
	var tableBody = $("#settings-table tbody");
	for (var x = 0; x < fields.length; x++) {
		var field = fields[x];
		var row = $('<tr/>');
		buildInputRow(row, field);
		tableBody.append(row);
	}
	callback();
	$('.btn-help').each(function() {
		$(this).popover({
			animation : true,
			container : $(this),
			trigger : 'click hover focus'
		});
	});
}

function findMemberByKey(grp, keyvalue) {
	if (!grp)
		return null;
	if (!keyvalue)
		return null;
	if (!grp.members)
		return null;
	for (var ndx = 0; ndx < grp.members.length; ndx++) {
		if (0 == grp.members[ndx].key.indexOf(keyvalue))
			return grp.members[ndx];
	}
	return null;
}

function appendThreshold2Element(element, threshold) {
	if (!element)
		return;
	if (!threshold)
		return;
	var divName = document.createElement("div");
	divName.setAttribute("class", "threshold-name-span");
	divName.appendChild(document.createTextNode(threshold.colorname));
	element.appendChild(divName);
	var divTable = document.createElement("div");
	divTable.setAttribute("class", "threshold-table");
	var ctrl = RetroLevelControlClass.setCtrlValue(threshold);
	divName.innerHTML = ctrl.getHtml();
	element.appendChild(divName);
}

function buildRetroGroup(grp, tblGroup) {
	if (!tblGroup)
		return;
	var row = document.createElement("tr");
	tblGroup.appendChild(row);
	var cell = document.createElement("td");
	row.appendChild(cell);
	cell.setAttribute("colspan", "2");

	var spanHelp = document.createElement("span");
	spanHelp.innerHTML = buildHelpButton({
		description : grp.description,
		help : grp.help
	});
	var desc = document.createElement("span");
	desc.setAttribute("class", "settings_input_label");
	desc.appendChild(document.createTextNode(grp.description));
	cell.appendChild(desc);
	cell.appendChild(spanHelp);
	appendThreshold2Element(cell, findMemberByKey(grp, RetroLevelControlClass.RETRO_THRESHOLD_KEY + RetroLevelControlClass.ctrlYellow.name)); // "RTHRYellow"
	appendThreshold2Element(cell, findMemberByKey(grp, RetroLevelControlClass.RETRO_THRESHOLD_KEY + RetroLevelControlClass.ctrlWhite.name)); // "RTHRWhite"

	row = document.createElement("tr");
	tblGroup.appendChild(row);
	cell = document.createElement("td");
	row.appendChild(cell);
	cell.setAttribute("colspan", "2");
	var stripy = document.createElement("span");
	stripy.setAttribute("class", "settings_input_label");
	var stripewidth = grp.stripewidth ? grp.stripewidth : "Stripe Width";
	stripy.appendChild(document.createTextNode(stripewidth));
	cell.appendChild(stripy);
	row = document.createElement("tr");
	row.innerHTML = buildInputRow($('<tr/>'), findMemberByKey(grp, "RMAS"));
	tblGroup.appendChild(row);
	row = document.createElement("tr");
	row.innerHTML = buildInputRow($('<tr/>'), findMemberByKey(grp, "RMIS"));
	tblGroup.appendChild(row);
}

var glyphicon = [ "", "<span class='glyphicon icon-Condition_1'></span>", "<span class='glyphicon icon-Condition_2'></span>", "<span class='glyphicon icon-Condition_3'></span>" ]

function buildRoadGroup(grp, tblGroup) {
	if (!tblGroup)
		return;
	var row = document.createElement("tr");
	tblGroup.appendChild(row);
	var cell = document.createElement("td");
	row.appendChild(cell);
	cell.setAttribute("colspan", "2");

	var description = document.createElement("label");
	description.setAttribute("class", "settings_input_label");
	description.appendChild(document.createTextNode(grp.help.help));
	cell.appendChild(description);
	var ulHelp = document.createElement("ul");
	ulHelp.setAttribute("class", "road-help-list");
	for (var ndx = 0; ndx < grp.help.options.length; ndx++) {
		var li = document.createElement("li");
		li.setAttribute("class", "road-help-item");
		var html = "";
		html += ndx.toString() + ": ";
		html += glyphicon[ndx];
		html += grp.help.options[ndx];
		li.innerHTML = html;
		ulHelp.appendChild(li);
	}
	cell.appendChild(ulHelp);

	var halfNdx = Math.floor(grp.members.length / 2);
	for (var ndx = 0; ndx < halfNdx; ndx++) {
		var row = document.createElement("tr");
		tblGroup.appendChild(row);
		var cell = document.createElement("td");
		cell.setAttribute("class", "halfwidth");
		row.appendChild(cell);
		appendRoad2Element(cell, grp.members[ndx]);
		cell = document.createElement("td");
		cell.setAttribute("class", "halfwidth");
		row.appendChild(cell);
		appendRoad2Element(cell, grp.members[ndx + halfNdx]);
	}
}

function appendRoad2Element(element, road) {
	if (!element)
		return;
	if (!road)
		return;
	var tmpTable = document.createElement("table");
	tmpTable.setAttribute("class", "road-condition-table");
	element.appendChild(tmpTable);
	var tmpBody = document.createElement("tbody");
	tmpBody.setAttribute("class", "road-condition-tbody");
	tmpTable.appendChild(tmpBody);
	var row = document.createElement("tr");
	row.setAttribute("class", "road-condition-row");
	tmpTable.appendChild(row);
	// label
	var cell = document.createElement("td");
	cell.setAttribute("class", "road-condition-cell");
	row.appendChild(cell);
	var span = document.createElement("span");
	span.setAttribute("class", "settings_input_label road-condition-label");
	span.appendChild(document.createTextNode(road.key));
	cell.appendChild(span);
	// input
	cell = document.createElement("td");
	cell.setAttribute("class", "road-condition-cell");
	row.appendChild(cell);
	cell.innerHTML = '<input type="text" formid="foo" id="' + road.key + '" class="field-input form-control ll-settings" value="' + road.value + '">';
	// action
	cell = document.createElement("td");
	cell.setAttribute("class", "road-condition-cell");
	row.appendChild(cell);
	var html = "";
	html += "<ul class='road-radio-list'>";
	for (var ndx = 0; ndx < glyphicon.length; ndx++) {
		html += "<li class='radio-item settings_input_label'>";
		html += "<input type='radio' name='ACM" + road.index.toString() + "' value='" + ndx.toString() + "' class='road-radio-input field-input '";
		if (ndx == road.action)
			html += " checked";
		html += ">";
		html += ndx.toString() + ": ";
		html += glyphicon[ndx];
		html += "</li>"
	}
	html += "</ul>";
	cell.innerHTML = html;
}

function buildSettingsGroups(groups, callback) {
	laserluxNS.grps = []; // debugging var
	for (var ndx = 0; ndx < groups.length; ndx++) {
		var grp = groups[ndx];
		if (grp["key"]) {
			console.log("building " + grp.key + "...");
			laserluxNS.grps[laserluxNS.grps.length] = grp; // save for
			// debugging
			var container = document.getElementById("idSettingsContainer");
			if (!container)
				return;
			var tblGroup = document.createElement("table");
			tblGroup.setAttribute("class", "group table-striped");
			tblGroup.setAttribute("id", grp.key);
			container.appendChild(tblGroup);
			var tbodyGroup = document.createElement("tbody");
			tbodyGroup.setAttribute("class", "group table-striped");
			tbodyGroup.setAttribute("id", grp.key);
			tblGroup.appendChild(tbodyGroup);
			// legend
			if (grp.legend) {
				var row = document.createElement("tr");
				tbodyGroup.appendChild(row);
				var cell = document.createElement("td");
				row.appendChild(cell);
				cell.setAttribute("colspan", "2");
				var legend = document.createElement("div");
				legend.setAttribute("class", "legend");
				legend.appendChild(document.createTextNode(grp.legend));
				cell.appendChild(legend);
			}
			// groups
			if (grp.key.toLowerCase() == "idretrogroup") {
				buildRetroGroup(grp, tbodyGroup);
			} else if (grp.key.toLowerCase() == "idroadgroup") {
				buildRoadGroup(grp, tbodyGroup);
			} else {
				var fields = grp.members;
				if (fields) {
					for (var x = 0; x < fields.length; x++) {
						var field = fields[x];
						var row = $('<tr/>');
						var html = buildInputRow(row, field);
						var rowElement = document.createElement("tr");
						rowElement.innerHTML = html;
						tbodyGroup.appendChild(rowElement);
					}
				}
				console.log("finished buildint table.body for " + grp.key);
			}
		}
	}
	RetroLevelControlClass.addChangeHandlers(onThresholdChange);
	if (callback)
		callback();
	$('.btn-help').each(function() {
		$(this).popover({
			animation : true,
			container : $(this),
			trigger : 'click hover focus'
		});
	});
}

function onThresholdChange(lvl) {
	if (lvl) {
		var fields = lvl.getFields();
		sendUpdates(fields);
	}
}

// -------------------------------------------------------------------------------------------------
// functions extracted from document.ready
function submitDescription() {
	var fields = {};
	fields["DESC"] = $("#RDSC").val();
	sendUpdates(fields);
}

function changeControlButtonDisplay(newValue) {
	// 0=stopped, 1=paused, 2=recording, 3=transitioning
	if (newValue == 0) {
		$('#record-pause-image').removeClass('glyphicon-pause');
		$('#record-pause-image').addClass('glyphicon-record');
		$('#record-pause-image').removeClass('paused recording');
		$('#record-pause-image').addClass('stopped');
		$('#control-stop').hide();
		$('#label-scan-status').text(myTranslatedText.txtStopped);
	} else if (newValue == 1) {
		$('#record-pause-image').removeClass('glyphicon-pause');
		$('#record-pause-image').addClass('glyphicon-record');
		$('#record-pause-image').removeClass('stopped recording');
		$('#record-pause-image').addClass('paused');
		$('#control-stop').show();
		$('#label-scan-status').text(myTranslatedText.txtPaused);
	} else if (newValue == 2) {
		$('#record-pause-image').removeClass('glyphicon-record');
		$('#record-pause-image').addClass('glyphicon-pause');
		$('#record-pause-image').removeClass('paused stopped');
		$('#record-pause-image').addClass('recording');
		$('#control-stop').show();
		$('#label-scan-status').text(myTranslatedText.txtRecording);
	}
}

function updateSystemMessagesFromServer(systemMessageArray) {
	$('#system-messages').empty();
	var displayNum = $('#system-messages').data('max-message-display');
	for (i in systemMessageArray) {
		if (i >= displayNum) {
			break;
		}
		var message = systemMessageArray[i];
		if (message.value.length > 0) {
			var messageTag = buildSystemMessageTag(message);
			$('#system-messages').append(messageTag);
		}
	}
}

laserluxNS.timerFn = function() {
	if (window.location.pathname == "/home") {
		if (this.lastCheckedDttm == this.lastUpdateDttm) {
			this.connected = false;
			var html = "";
			html += "<h2>Last Update:" + this.lastUpdateDttm.toString() + "</h2>";
			html += "<h2>Currently:" + (new Date()).toString() + "</h2>";
			document.body.innerHTML = html;
			document.body.style.backgroundColor = "red";
		} else if (!this.connected) {
			var html = "";
			html += "<h2>Last Update:" + this.lastUpdateDttm.toString() + "</h2>";
			html += "<h2>Currently:" + (new Date()).toString() + "</h2>";
			html += "<hr>"
			html += "<h2>Reconnected!, refresh the page!</h2>";
			document.body.innerHTML = html;
			document.body.style.backgroundColor = "#00FF00";
			this.connected = true;
			window.location.reload(true);
		}
	}
	this.lastCheckedDttm = this.lastUpdateDttm;
}

// -----------------------------------------------------------------------------
// BEGIN updatePageFieldsFromServer
// -----------------------------------------------------------------------------
laserluxNS.activelyUpdating = false;
laserluxNS.updatingCntr = 0;
laserluxNS.updateMs = 0;
laserluxNS.updateInterval = 0;
function updatePageFieldsFromServer(data) {
	if (data == null) {
		return;
	}

	laserluxNS.updateInterval = Date.now() - laserluxNS.lastUpdateDttm.getTime();
	if (laserluxNS.activelyUpdating) {
		console.log("updatePageFieldsFromServer() overrun! interval: " + laserluxNS.updateInterval + "ms < update:" + laserluxNS.updateMs + "ms");
	}
	laserluxNS.activelyUpdating = true;
	laserluxNS.updatingCntr++;

	laserluxNS.lastUpdateDttm = new Date();
	if (data['SNUM']) {
		SNUM = data['SNUM'];
	}
	changeControlButtonDisplay(data['RCCO']);
	$('#RCCO').val(data['RCCO']);
	// set the graph's Y limit
	if (data['RYAR']) {
		y_axis_max = data['RYAR'];
	}
	// set the graph's RPM value
	if (data['RPML']) {
		rpm = data['RPML'];
	}
	$('label.GODO').each(function() {
		var id = $(this).attr('id');
		if (data[id] !== null) {
			$(this).text(data[id]);
		}
	});
	// Calibrate indicator
	if (data['SCPF'] !== undefined) {
		var value = data['SCPF'];
		var passText = "Pass";
		var failText = "Fail";
		var naText = "N/A";
		if (value == 2) {
			$('#SCPF').removeClass("fail");
			$('#SCPF').addClass("pass");
			$('#pass-fail-text').text(passText);
		} else if (value == 1) {
			$('#SCPF').removeClass("pass");
			$('#SCPF').addClass("fail");
			$('#pass-fail-text').text(failText);
		} else {
			$('#SCPF').removeClass("pass");
			$('#SCPF').removeClass("fail");
			$('#pass-fail-text').text(naText);
		}
	}
	if (data['SNCH'] != undefined) {
		if (data['SNCH'] == 2) {
			$('#IRFACTOR').show();
			$('#IRCALPLAQVAL').show();
		} else {
			$('#IRFACTOR').hide();
			$('#IRCALPLAQVAL').hide();
		}
	}
	// Leveling indicator
	if (data['SLLS'] !== undefined) {
		var value = data['SLLS'];
		if (value == 2) { // error
			$('#SLLS').removeClass("home levelok");
			$('#SLLS').addClass("error");
			$('#leveling-text').text(myTranslatedText.txtError);
		} else if (value == 1) { // level-ok
			$('#SLLS').removeClass("home error");
			$('#SLLS').addClass("levelok")
			$('#leveling-text').text(myTranslatedText.txtOK);
		} else { // home
			$('#SLLS').removeClass("error levelok");
			$('#SLLS').addClass("home");
			$('#leveling-text').text(myTranslatedText.txtHome);
		}
	}
	if (data['GFIX'] !== undefined) {
		var hasFix = (data['GFIX'] != "No Fix");
		var color = hasFix ? 'transparent' : 'red';
		$('#idNoGpsWatermark').css('color', color);
		$('#idGPSStatusTable').css('background-color', color);
		var elm = document.getElementById("idGPSPanelLabel");
		if (elm) {
			if (hasFix) {
				elm.onclick = null; // remove handler
				elm.textContent = "GPS";
			} else {
				elm.textContent = "No GPS Fix";
				elm.onclick = function() {
					var fields = {};
					fields["GRST"] = 1;
					sendUpdates(fields);
				}
			}
		}
	}

	// update bootstrap sliders
	$('input.slider').each(function() {
		var id = $(this).attr('id');
		if (data[id] !== undefined) {
			$(this).slider('setValue', data[id]);
		}
	});

	$('input.field-input').each(function() {
		var id = $(this).attr('id');
		if (data[id] !== undefined && /* !$(this).is( ":focus" ) */this != document.activeElement) {
			if ($(this).attr('type') == "number" && $(this).attr('decimals') !== undefined) {
				var decimals = parseInt($(this).attr('decimals'));
				var decade = Math.pow(10, decimals);
				var val = data[id];
				var valX10 = val * decade;
				var valTrun = Math.round(valX10);
				var val2Show = valTrun / decade;
				$(this).val(val2Show);
			} else {
				$(this).val(data[id]);
			}
		}
	});

	// update road type labels
	$('.btn-stripe').each(function() {
		var id = $(this).attr('id');
		if (data[id] !== undefined) {
			var active = data[id] == 1 ? true : false;
			$(this).toggleClass('active', active);
			if (window.StripChartClass && active) {
				StripChartClass.stripeTypeId = id;
			}
		}
	});

	// update road condition labels
	$('text.label-road').each(function() {
		var id = $(this).attr('id');
		if (data[id] !== undefined) {
			$(this).text(data[id]);
		}
	});

	// update road condition timed icons
	$('span.road-condition-type-icon').each(function() {
		var id = $(this).attr('id');
		if (data[id] !== undefined) {
			switch (data[id]) {
			case 0: // none
				$(this).toggleClass('icon-Condition_0', false);		// Eric N doesn't want an icon at all for road condition type 0. Erik S disagrees but Eric N is the boss.
				$(this).toggleClass('icon-Condition_1', false);
				$(this).toggleClass('icon-Condition_2', false);
				$(this).toggleClass('icon-Condition_3', false);
				break;
			case 1: // auto pause
				$(this).toggleClass('icon-Condition_0', false);
				$(this).toggleClass('icon-Condition_1', true);
				$(this).toggleClass('icon-Condition_2', false);
				$(this).toggleClass('icon-Condition_3', false);
				break;
			case 2: // momentary
				$(this).toggleClass('icon-Condition_0', false);
				$(this).toggleClass('icon-Condition_1', false);
				$(this).toggleClass('icon-Condition_2', true);
				$(this).toggleClass('icon-Condition_3', false);
				break;
			case 3: // momentary with data save
				$(this).toggleClass('icon-Condition_0', false);
				$(this).toggleClass('icon-Condition_1', false);
				$(this).toggleClass('icon-Condition_2', false);
				$(this).toggleClass('icon-Condition_3', true);
				break;

			}
		}
	});

	for ( var prop in data) {
		if (prop != null) {
			var htmlField = $('#' + prop);
			var value = data[prop];
			// Fractional numbers now have an decimals specifier (default=1)
			if (typeof value === 'number' && 0 < htmlField.length) {
				// can just skip since all 'number' fields are also
				// 'input.field-input' which have already been
				// set
				if (null != htmlField[0].getAttribute("decimals")) {
					var decimals = parseInt(htmlField[0].getAttribute("decimals"));
					value = value.toFixed(decimals);
				} else {
					if (value % 1 != 0) {
						value = value.toFixed(1);
					}
				}
			}
			if (prop == "RDSC")
				continue;
			if (prop == "RDSF")
				continue;
			if (window.StripChartClass && prop == window.StripChartClass.RETRO_STRIP_CHART_DATA_KEY) {
				window.StripChartClass.readProp(data[window.StripChartClass.RETRO_STRIP_CHART_DATA_KEY]);
				continue;
			}
			for (var ndx = 0; ndx < radioCtrls.length; ndx++) {
				var ctrl = radioCtrls[ndx];
				if (ctrl.tagname == prop) {
					var suffix = value == 1 ? "on" : "off";
					// var rdoOn = document.getElementById("rdo" + ctrl.tagname
					// + "on");
					// var rdoOff = document.getElementById("rdo" + ctrl.tagname
					// + "off");
					var rdoOn = $('#rdo' + ctrl.tagname + 'on');
					var rdoOff = $('#rdo' + ctrl.tagname + 'off');
					if (rdoOn && rdoOff) {
						rdoOn.toggleClass('input-radio-active', value == 1);
						rdoOn.text(value == 1 ? "X" : "");
						rdoOff.toggleClass('input-radio-active', value != 1);
						rdoOff.text(value == 1 ? "" : "X");
					}
					if (prop == "RPFC" && window.StripChartClass) {
						window.StripChartClass.setStripColorNdx(value);
					}
					break;
				}
			}
			if (htmlField.length) {
				if (htmlField.hasClass('btn')) {
					var active = value == "1" ? true : false;
					htmlField.toggleClass('active', active);
					continue;
				}
				if (htmlField.hasClass("btn-stripe")) {
					// var active = value == "1" ? true : false;
					// htmlField.toggleClass('active', active);
					// processed above, just 'continue' here
					continue;
				}
				// don't update the text of the road type icon
				if (htmlField.hasClass('road-condition-type-icon')) {
					continue;
				}
				if (htmlField.hasClass('input-radio')) {
					// never gets here 'cause htmlField is empty
					continue;
				}
				if (prop == 'SCPF') {
					continue;
				}
				if (prop == 'SLLS') {
					continue;
				}
				if (htmlField[0] == document.activeElement)
					continue;
				htmlField.text(value);
			}
		}
	}
	laserluxNS.lastData = data;
	laserluxNS.updateMs = Date.now() - laserluxNS.lastUpdateDttm.getTime();
	laserluxNS.updatingCntr--;
	laserluxNS.activelyUpdating = false;
}
// END updatePageFieldsFromServer
// -----------------------------------------------------------------------------

// -------------------------------------------------------------------------------------------------
// document.ready
$(document).ready(function() {
	console.log("loading page values");
	// hide ios keyboard when user hit return
	$(document).on("keyup", "input", function(event) {
		// If enter is pressed then hide keyboard.
		if (event.keyCode == 13) {
			$("input").blur();
		}
		return true;
	});

	// all pages get system messages
	var sysMsgSocket = io.connect('/sys_msg');
	sysMsgSocket.on('systemMessages', function(data) {
		// console.log(JSON.stringify(data));
		updateSystemMessagesFromServer(data.SMSG);
	});

	// hook up events to controls
	var pageId = window.location.pathname;
	// if ($('title').text() == "Laserlux")
	if (pageId == "/home") {
		var colorChar = null;
		var scanGraph = new ScanGraph(document.getElementById('wave'), SNUM);
		var response = getFields([ 'SGHL' ], function(data) {
			translateLabels(data.SGHL, function() {
				// console.log("done translating SGHL labels");
				if (window.StripChartClass) {
					// now get RTHR for StripChartClass
					getFields([ 'RTHR' ], function(data) {
						for (var ndx = 0; ndx < data["RTHR"].length; ndx++) {
							var obj = data["RTHR"][ndx];
							RetroLevelControlClass.setCtrlValue(obj);
						}
						console.log("done recieving RTHR values");
					});
				}
			});
		});
		var homeSocket = io.connect('/home');
		homeSocket.on('homeValues', function(data) {
			updatePageFieldsFromServer(data);
		});

		var jensSocket = io.connect('/graph');
		// Listen for Socket.io emit for scan values
		jensSocket.on('jens', function(data) {
			try {
				points = new Float32Array(data);
			} catch (e) {
				console.log(e);
			}
		});
	} else if (pageId == "/status") {
		var statusSocket = io.connect("/status");
		statusSocket.on('statusData', function(data) {
			var payloadStr = "";
			if (myTextDecoder != null) {
				payloadStr = myTextDecoder.decode(data);
				if (payloadStr.charCodeAt(0) == 27 && 6 < payloadStr.length)
					payloadStr = payloadStr.substr(6);
			} else {
				// does not properly decode °C
				payloadStr = String.fromCharCode.apply(null, new Uint8Array(data, 6));
			}
			$('#terminal-area').val(payloadStr);
			// $('#terminal-area').val($('#terminal-area').val() + payloadStr);
			// $('#terminal-area').val("foo");
		});
	}
	// if ($('title').text() == "Settings")
	else if (pageId == "/settings") {
		// when the Settings page loads, we need
		// to populate values.
		var request = [ 'SGUT' ];
		var response = getFields(request, function(data) {
			buildSettingsGroups(data.SGUT, function() {
				// console.log("done building SGUT groups");
				getFields([ 'SGUL' ], function(data) {
					translateLabels(data.SGUL, function() {
						console.log("done building SGUT groups");
					});
				});
			});
		});
		var homeSocket = io.connect('/settings');
		homeSocket.on('settingsValues', function(data) {
			updatePageFieldsFromServer(data);
		});
	}
	// if ($('title').text() == "Engineering Settings")
	else if (pageId == "/settings_eng") {
		// when the Settings page loads, we need
		// to popularte values.
		var request = [ 'SGET' ];
		var response = getFields(request, function(data) {
			buildEngrSettingsTable(data.SGET, function() {
				console.log("done building SGET table");
			});
		});
	}

	// Hook events for main control buttons (pause, record, stop)
	$('.btn-control').each(function(index, item) {
		function clicked(event) {
			// 0=stopped, 1=paused, 2=recording
			var id = event.data.item.attr('id');
			var oldValue = $('#RCCO').val();
			// calculate new value, which depends on
			// which button was clicked and what the old value was
			var newValue = 0;
			if (id == 'control-record-pause') { // record-pause
				if (oldValue == 0 || oldValue == 1) {
					// send 2 for record
					newValue = 2;
				} else if (oldValue = 2) {
					// send 1 for pause
					newValue = 1;
				}
			} else if (id == 'control-stop') {// stop
				newValue = 0;
			}
			var fields = {};
			fields['RCCO'] = parseInt(newValue);
			sendUpdates(fields);
			$('#RCCO').val(newValue);
			if (window.StripChartClass && newValue == 0)
				StripChartClass.getCtx(); // clear strip chart
		}
		$(item).on('click', {
			item : $(item)
		}, clicked);
	});

	$('.btn').each(function(index, item) {
		function clicked(event) {
			var id = event.data.item.attr('id');
			var newVal = event.data.item.hasClass('active') ? 0 : 1;
			var fields = {};
			fields[id] = newVal;
			sendUpdates(fields);
		}
		$(item).on('click', {
			item : $(item)
		}, clicked);
	});

	$('.btn-road').each(function(index, item) {
		function clicked(event) {
			var id = event.data.item.attr('id');
			var newVal = event.data.item.hasClass('active') ? 0 : 1;
			console.log(id + " clicked");
			var acm = document.getElementById("ACM" + id.substring(3));
			if (-1 < acm.className.indexOf("map-marker")) {
				var acn = document.getElementById(id);
				acn.style.backgroundColor = "Yellow";
			    setTimeout(() => { document.getElementById(id).style.backgroundColor = ""; }, 1000);
			}
		}
		$(item).on('click', {
			item : $(item)
		}, clicked);
	});

	$('.btn-stripe').each(function(index, item) {
		function clicked(event) {
			var id = event.data.item.attr('id');
			var newVal = event.data.item.hasClass('active') ? 0 : 1;
			if (newVal == 1) {
				// update display
				$('.btn-stripe').each(function() {
					var id = $(this).attr('id');
					if ($(this).hasClass('active'))
						$(this).removeClass('active');
				});
				event.data.item.addClass('active');
				// send value to 'C' code
				var fields = {};
				fields[id] = newVal;
				sendUpdates(fields);
			}
		}
		$(item).on('click', {
			item : $(item)
		}, clicked);
	});

	$('.roadtype').each(function(index, item) {
		// $(.item).button();
		function clicked(event) {
			var id = event.data.item.attr('id');
			var newVal = 1;
			var fields = {};
			fields[id] = newVal;
			sendUpdates(fields);
		}
		$(item).on('click', {
			item : $(item)
		}, clicked);
	});

	$('input.slider-input').each(function(index, item) {
		$(item).on('change', function(event) {
			var fields = {};
			var newVal = parseFloat(event.target.value);
			fields[event.target.id] = newVal;
			sendUpdates(fields);
			y_axis_max = $('#RYAR').val();
			rpm = $('#RPML').val();
		});
	});

	$('.input-radio').each(function(index, item) {
		function clicked(event) {
			var name = event.data.item.attr('name');
			var newVal = Number(event.data.item.attr('value'));
			if (name == "GDIR" && document.getElementById('RCCO').value != "0") {
				console.log("invalid operation: attempted to change GDIR while recording");
			} else {
				var fields = {};
				fields[name] = newVal;
				sendUpdates(fields);
			}
		}
		$(item).on('click', {
			item : $(item)
		}, clicked);
	});

	$(document).on('change', 'input.field-input', function(event) {
		$(this).closest('form').submit();
		var fields = {};
		if (event.target.type == 'number') {
			fields[event.target.id] = parseFloat(event.target.value);
		} else if (event.target.type == 'radio') {
			fields[event.target.name] = parseInt(event.target.value);
		} else // if ( event.target.type == 'text')
		{
			fields[event.target.id] = event.target.value;
		}
		sendUpdates(fields);
	});

	$(document).on('change', 'select.field-input', function(event) {
		// $(this).closest('form').submit();
		var fields = {};
		fields[event.target.id] = event.target.value;
		sendUpdates(fields);
	});

	$('form.ll-submit-form').each(function(e, item) {
		$(item).on('submit', function(event) {
			if (this.checkValidity && !this.checkValidity()) {
				$(this).find(":invalid").first().focus();
				event.preventDefault();
			}
			event.preventDefault();
		});
	});

	$('form.ll-submit-form input').on('invalid', function(e) {
		console.log('invalid');
	});

	$("#description-form").submit(function(event) {
		submitDescription();
		event.preventDefault();
	});

	$("#description-button").on("click", function(event) {
		submitDescription();
	});

	laserluxNS.timeID = setInterval(function() {
		laserluxNS.timerFn();
	}, 30000); // 30
	// secs
});
