/*
 * laserluxKmlTranslator_cmd.js
 */
 
var version = '2.0'
 
console.log('Laserlux KML Translator Command Processor Version ' + version); 
if (process.argv.length < 3) {
	console.log('Usage: node laserluxKmlTranslator_cmd fileName [outputPath] [custom KML overlay] [value(Valid),R(Valid),G(Valid),B(Valid)] [repeat for Marginal0, Marginal1, Marginal2, Good]')
	return;
}
var fs = require('fs');
var kmlTranslator = require('./laserluxKmlTranslator.js');
var filename = process.argv[2];
var outpath = '';
console.log(process.argv.length + ' Process Arguments Found');

if (process.argv.length > 3) {			// explicit output path
	outpath = process.argv[3];
}
else {									// use same path as input
	var str = process.argv[2];
	var fb = str.substring(0,str.lastIndexOf('.'));
	outpath = fb+'.kml';
}

if (process.argv.length > 4) {			
	var image_str = process.argv[4];
	var params = {overlayLink:(process.argv[4])};
	console.log("Will use " + image_str + " as custom KML image overlay");
}

if (process.argv.length > 5) {
	if (process.argv.length < 25) {
		console.log('You must enter value,R,G,B for each of the 5 limits (valid, marginal0, marginal1, marginal2, good)');
		return;
	}
	if (process.argv.length > 25) {
		console.log('Too many process arguements');
		return;
	}
	var params = {	overlayLink:(process.argv[4]),
					validMin:parseFloat(process.argv[5]),
					validR:parseInt(process.argv[6]),
					validG:parseInt(process.argv[7]),
					validB:parseInt(process.argv[8]),
					marginal_0Min:parseFloat(process.argv[9]),
					marginal_0R:parseInt(process.argv[10]),
					marginal_0G:parseInt(process.argv[11]),
					marginal_0B:parseInt(process.argv[12]),
					marginal_1Min:parseFloat(process.argv[13]),					
					marginal_1R:parseInt(process.argv[14]),
					marginal_1G:parseInt(process.argv[15]),
					marginal_1B:parseInt(process.argv[16]),
					marginal_2Min:parseFloat(process.argv[17]),
					marginal_2R:parseInt(process.argv[18]),
					marginal_2G:parseInt(process.argv[19]),
					marginal_2B:parseInt(process.argv[20]),		
					goodMin:parseFloat(process.argv[21]),
					goodR:parseInt(process.argv[22]),
					goodG:parseInt(process.argv[23]),
					goodB:parseInt(process.argv[24])};						
}

console.log('Converting ' + filename + " to " + outpath);

fs.readFile(filename,'utf8',function(err,data) {
        if (err) {
            return console.log(err);
        }
        fs.writeFile(outpath,kmlTranslator.conv(data,params));
});


